// ################################################################################
//
//  Display Test vB0
//
//  Released:  24/12/2024
//
//  Author: TechKnowTone
//
// ################################################################################
/*
    TERMS OF USE: This software is furnished "as is", without technical support, and
    with no warranty, expressed or implied, as to its usefulness for any purpose. In
    no event shall the author or copyright holder be liable for any claim, damages,
    or other liability, whether in an action of contract, tort or otherwise, arising
    from, out of or in connection with the software or the use or other dealings in
    the software.

    microcontroller: ESP32 Dev Module   v3.0.2

    This code was writtent to confirm the function of the OLED display, which uses
    the SSD1306 controller. Use this as a quick test for ensuring that the display is
    working and positioned correctly in the case.

    Enjoy!
*/
// Declare libraries
#include <Adafruit_GFX.h>     // version 1.11.10
#include "SSD1306Wire.h"      // OLED display library

// Configuration
String Release = "Display Test ";
String Date = "24/06/2024";
String Rev = "vB0";

// Display Settings
const int I2C_DISPLAY_ADDRESS = 0x3c;
const int SDA_PIN = 21;        // I2C SDA GPIO pin
const int SCL_PIN = 22;        // I2C SCL GPIO pin

// Initialize the oled display for address 0x3c
SSD1306Wire display(I2C_DISPLAY_ADDRESS, SDA_PIN, SCL_PIN);

// Define constants
#define Xoff 32                 // X offset needed in 64x48 OLED display
#define Yoff 16                 // Y offset needed for flipped 64x48 OLED display

int16_t Thr = 0;                // time hours digit
int32_t Tinc = 0;               // time increment tracker
int16_t Tmin = 0;               // time minutes digit
int16_t Tsec = 0;               // time seconds digit

// --------------------------------------------------------------------------------

void setup() {
  Serial.begin(115200);
  delay(100);
  Serial.println(Release + Rev);
  Serial.println(Date);
  
  // Initialise display
  OLED_Init();
  OLED_Update();
  Serial.println("Display initialised");
}

// --------------------------------------------------------------------------------

void loop(void) {
  // Here we ait for the time to change by 1 second, then update the display
  if ((millis()/1000) > Tinc) {
    // Time has changed by 1 second
    Tinc++;                       // update the 1 second tracker
    Tsec++;                       // update the 1 second digit
    if (Tsec > 59) {
      // seconds digit has reached 1 minute
      Tsec = 0;                   // zero seconds digit
      Tmin++;                     // increment minutes digits
      if (Tmin > 59) {
        // minutes have reached 1 hour
        Tmin = 0;                 // zero minutes
        Thr++;                    // increment hours
        if (Thr > 23) {Thr = 0;}  // ensure hours does not exceed 23
      }
    }
    OLED_Update();
  }
}

// --------------------------------------------------------------------------------

String get2char(int16_t zT) {
  // returns a two character version of zT
  String zR = String(zT);
  if (zR.length() < 2) {zR = "0" + zR;}
  return zR;
}

// --------------------------------------------------------------------------------

void OLED_Init() {
  // Initialise the OLED display
  display.init();
  display.clear();
  display.setContrast(31);
  display.flipScreenVertically();   // use this with Yoff=16, when display is upside down
  display.display();
}

// --------------------------------------------------------------------------------

void OLED_Update() {
  // First screen to be displayed
  // default fonts are ArialMT_Plain_10, ArialMT_Plain_16 and ArialMT_Plain_24
  display.clear();
  display.drawRect(Xoff,Yoff,64,48); // draw a box around the screen
  display.setFont(ArialMT_Plain_10);
  // Y48 vertical text spacing, from Y=0 to Y=47
  // 012345678901234567890123456789012345678901234567
  //     1111111111  2222222222        3333333333
  display.setTextAlignment(TEXT_ALIGN_CENTER);
  display.drawString(Xoff+32,Yoff+4, "Omni-Bot");
  display.drawString(Xoff+32,Yoff+16, Rev);
  display.drawString(Xoff+32,Yoff+34, get2char(Thr) + ":" + get2char(Tmin) + ":" + get2char(Tsec));
  display.display();
}

// --------------------------------------------------------------------------------

